IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Vista_Integration_Log]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Vista_Integration_Log]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Valentinm
-- Create date: 06/29/2012
-- Description: Get vista integration log.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Vista_Integration_Log]
	@IENS VARCHAR(MAX),
	@VISTA_FILES VARCHAR(MAX),
	@VISTA VARCHAR(50)
AS
SET NOCOUNT ON
BEGIN

	SELECT V.IEN, V.VISTA_FILE
	FROM dbo.VISTA_INTEGRATION_LOG AS V
		INNER JOIN dbo.fn_Split_String(@IENS, ',') AS A ON V.IEN = A.VALUE
	WHERE V.VISTA_FILE = CONVERT(CHAR(2), @VISTA_FILES) AND V.VISTA = @VISTA

END
GO


